import React, { useState, useEffect } from 'react';
import pru from '../assets/pru.png';
import Estrellas from './Estrellas';
import '../estilos/Videos.css';

import harry from '../assets/testimonio/01.jpg'; 
import carlos from '../assets/testimonio/02.jpg'; 
import jeanca from '../assets/testimonio/Juan-Carlos.jpeg'; 
import diego from '../assets/testimonio/Diego-Orellana.jpeg'; 
import alejandro from '../assets/testimonio/alejandro.jpeg'; 
import fernando from '../assets/testimonio/fernando.jpeg'; 


const comentarios = [
  { 
    nombre: "Harry Gonzales", 
    puntuacion: 5, 
    rango: "Campeón del torneo de poker en Quito", 
    avatar: harry,
    comentario: "Participar en el torneo de poker en Quito fue una experiencia inolvidable. La emoción del juego y la comunidad de jugadores hicieron que el evento fuera espectacular." // Comentario de Juan Pérez
  },
  { 
    nombre: "Carlos Flores", 
    puntuacion: 4.8, 
    rango: "Finalista del torneo de poker en Quito", 
    avatar: carlos,
    comentario: "El torneo de poker en Quito fue desafiante, pero la adrenalina y el ambiente competitivo hicieron que todo valiera la pena. ¡Ya espero con ansias el próximo evento presencial de poker en Ecuador!" // Comentario de Carlos Ruiz
  },
  { 
    nombre: "Juan Carlos García Pangorita", 
    puntuacion: 4.8, 
    rango: "", 
    avatar: jeanca,
    comentario: "Después de varias manos intensas, mi estrategia de farol realmente marcó la diferencia. Fue una experiencia reveladora sobre el poder del juego psicológico en el poker." // Comentario de Ana Martínez
  },
  { 
    nombre: "Diego Orellana", 
    puntuacion: 5, 
    rango: "Finalista del torneo de poker en Quito", 
    avatar: diego,
    comentario: "La experiencia en el torneo me enseñó a leer a los oponentes con mayor precisión. Cada mano era un desafío y aprendí mucho sobre el arte de la negociación en el poker." // Comentario de Luis González
  },
  { 
    nombre: "Alejandro Ortiz", 
    puntuacion: 5, 
    rango: "Jugador profesional de poker", 
    avatar: alejandro,
    comentario: "es un orgullo representar a Ecuador en una serie tan importante. Vinimos a probar nuestro nivel. El TEAM ECUAPOKER se extiende. Lo hemos hecho bien, hemos tomado buenas decisiones, hemos jugado con rivales de otro nivel, y lo hemos hecho bien" // Comentario de Luis González
  },
  { 
    nombre: "Luis Fernando Velasquez", 
    puntuacion: 5, 
    rango: "Jugador profesional de poker", 
    avatar: fernando,
    comentario: "Por mi lado también una experiencia muy grata. Ahí vamos, dándole con todo, aprendiendo de estas experiencias" // Comentario de Luis González
  },
];

const Videos = () => {
  const [comentarioIndex, setComentarioIndex] = useState(0);

  
  useEffect(() => {
    const interval = setInterval(() => {
      setComentarioIndex((prevIndex) => (prevIndex + 2) % comentarios.length);
    }, 5000);

    return () => clearInterval(interval);
  }, []);

  
  const mostrarEstrellas = (puntuacion) => {
    const estrellas = [];
    for (let i = 1; i <= 5; i++) {
      estrellas.push(i <= puntuacion ? "★" : "☆");
    }
    return estrellas.join(" ");
  };

  return (
    <div className="videos" style={{ backgroundImage: `url(${pru})` }}>
      <Estrellas />

  
      <div className="video-container">
        <iframe
          width="100%"
          height="100%"
          src="https://www.youtube.com/embed/hmVTrdNy6E8?si=9qZOVrH5F9MHjQ2T" 
          title="Entrevista con nuestros jugadores de Poker"
          frameBorder="0"
          allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
          allowFullScreen
        ></iframe>
      </div>

      <div className="textorres">
      
      </div>
      <div className='olamundo'>
      <p className="sinsentimientocorazonfrio">Descubre las experiencias y estrategias de nuestros jugadores <br/>en los torneos más destacados de poker en Ecuador.</p>
      </div>
      <div className="comentarios">
  
  {[comentarios[comentarioIndex], comentarios[(comentarioIndex + 1) % comentarios.length]].map((comentario, index) => (
    <div key={index} className="comentario">
      <img src={comentario.avatar} alt="Jugador" className="avatar" />
      <div className="comentario-texto">
        <p className="nombre">{comentario.nombre}</p>
        <p className="puntuacion">
          {mostrarEstrellas(comentario.puntuacion)}
        </p>
        <p className="rango">{comentario.rango}</p>
          <p className="contenido">{comentario.comentario}</p> 
      </div>
    </div>
  ))}
</div>
    </div>
  );
};

export default Videos;
