// Estrellas.js
import React from 'react';

const Estrellas = () => {
  const generateStars = (numStars) => {
    const stars = [];
    for (let i = 0; i < numStars; i++) {
      const x = Math.random() * 100; 
      const y = Math.random() * 100; 
      const size = Math.random() * 1 + 0.5; 
      const opacity = Math.random() * 0.6 + 0.4; 
      
      stars.push({ x, y, size, opacity });
    }
    return stars;
  };

  const starsStyle = {
    position: 'absolute',
    top: 0,
    left: 0,
    width: '100%',
    height: '100%',
    pointerEvents: 'none', 
    zIndex: 1, // Asegurarse de que esté en el fondo
  };

  const stars = generateStars(200);

  return (
    <div style={starsStyle}>
      {stars.map((star, index) => (
        <div
          key={index}
          style={{
            position: 'absolute',
            top: `${star.y}%`,
            left: `${star.x}%`,
            width: `${star.size}px`,
            height: `${star.size}px`,
            backgroundColor: 'yellow',
            borderRadius: '50%',
            opacity: star.opacity,
            boxShadow: `0 0 ${star.size * 2}px white`,
            
          }}
        />
      ))}
    </div>
  );
};

export default Estrellas; // Asegúrate de usar `default export`
