import React, { useState } from "react";
import { Modal, Button, Input, Radio, Form, Row, Col, Tabs } from "antd";



const ErrorModal = ({ isOpen, onClose, type, message }) => {




  return (
    <Modal
      open={isOpen}
      onCancel={onClose}
      footer={null}
      title={type === "form" ? "Formulario de error" : message}
      width="100%"
      style={{ maxWidth: "600px" }}
      destroyOnClose
    >


      (
      <>
        <p>{message}</p>
        <Button type="primary" onClick={onClose}>
          Cerrar
        </Button>
      </>
      )
    </Modal>
  );
};

export default ErrorModal;
