<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class RoleSeeder extends Seeder
{
    public function run()
    {
        // Crear roles
        $adminRole = Role::create(['name' => 'admin']);
        $editorRole = Role::create(['name' => 'editor']);
        $userRole = Role::create(['name' => 'user']);

        // Crear permisos
        $createPost = Permission::create(['name' => 'create posts']);
        $editPost = Permission::create(['name' => 'edit posts']);
        $deletePost = Permission::create(['name' => 'delete posts']);

        // Asignar permisos a roles
        $adminRole->givePermissionTo([$createPost, $editPost, $deletePost]);
        $editorRole->givePermissionTo([$createPost, $editPost]);

        // Crear un usuario admin
        $admin = User::create([
            'name' => 'Admin',
            'email' => 'admin@example.com',
            'password' => bcrypt('password'),
        ]);

        // Asignar rol al usuario
        $admin->assignRole('admin');
    }
}
