<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('proviene_productos', function (Blueprint $table) {
            $table->id('id_proviene_producto'); // Autoincremental
            $table->string('direccion')->nullable(false); // No puede ser null
            $table->boolean('estado')->default(1); // No puede ser null, por defecto activo
            $table->text('descripcion')->nullable(false); // No puede ser null
            $table->string('origen')->nullable(false); // No puede ser null
            $table->timestamps(); // Crea created_at y updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('proviene_productos');
    }
};
