<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('departamentos', function (Blueprint $table) {
            $table->id('id_departamento'); // Autoincremental
            $table->text('descripcion')->nullable(false); // No puede ser null
            $table->boolean('estado')->default(1); // No puede ser null, por defecto activo
            $table->unsignedBigInteger('id_sucursal'); // Clave foránea
            $table->timestamps(); // Crea created_at y updated_at

            // Definir la clave foránea
            $table->foreign('id_sucursal')->references('id_sucursal')->on('sucursales')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('departamentos');
    }
};
