<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('sucursales', function (Blueprint $table) {
            $table->id('id_sucursal'); // Autoincremental
            $table->boolean('estado')->default(1); // No puede ser null, por defecto activo
            $table->string('ubicacion')->nullable(false); // No puede ser null
            $table->text('descripcion')->nullable(false); // No puede ser null
            $table->timestamps(); // Crea created_at y updated_at
        });
    }

    public function down()
    {
        Schema::dropIfExists('sucursales');
    }
};
