<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    // LOGIN DESDE VISTA
    public function showLoginForm()
    {
        return view('auth.login');
    }

    // INICIAR SESIÓN
    public function login(Request $request)
    {
        $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]);

        $user = User::where('email', $request->email)->first();

        if (!$user || !Hash::check($request->password, $user->password)) {
            return back()->withErrors(['email' => 'Credenciales inválidas'])->withInput();
        }

        // Si quieres mantener el login con token en sesión también
        Auth::login($user);

        // Generar token Sanctum
        $token = $user->createToken('auth_token')->plainTextToken;

        return redirect()->route('productos.welcome')->with('token', $token);
    }

    // REGISTRO SOLO API
    public function register(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:150',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|confirmed|min:6',
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => bcrypt($request->password),
        ]);

        return response()->json([
            'message' => 'Usuario creado exitosamente',
            'user' => $user
        ]);
    }
    public function destroy(Request $request)
    {
        Auth::logout(); // Cierra la sesión

        $request->session()->invalidate(); // Invalida la sesión actual
        $request->session()->regenerateToken(); // Regenera el token CSRF

        return redirect('/login'); // Redirige al login
    }
}
